/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TabAddMode;
import net.mehvahdjukaar.every_compat.api.TextureInfo;
import net.mehvahdjukaar.every_compat.configs.ModEntriesConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.ColoringUtils;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleEntrySet<T extends BlockType, B extends class_2248, I extends class_1792>
implements EntrySet<T> {
    protected static final class_2960 NO_TAB_MARKER = new class_2960("none");
    public final Map<T, B> blocks = new HashMap<T, B>();
    public final Map<T, I> items = new HashMap<T, I>();
    protected final Class<T> type;
    protected final Pattern nameScheme;
    protected final Supplier<T> baseType;
    public final String typeName;
    public final String postfix;
    @Nullable
    public final String prefix;
    protected final boolean mergePalette;
    protected final Supplier<class_5321<class_1761>> tab;
    protected final TabAddMode tabMode;
    protected final Map<class_2960, Set<class_5321<?>>> tags = new HashMap();
    protected final Set<Supplier<class_2960>> recipeLocations = new HashSet<Supplier<class_2960>>();
    protected final Set<TextureInfo> textures = new HashSet<TextureInfo>();
    protected final BiFunction<T, class_3300, Pair<List<Palette>, @Nullable McMetaFile>> paletteSupplier;
    @Nullable
    protected final Consumer<BlockTypeResTransformer<T>> extraModelTransform;
    protected final Predicate<T> condition;
    protected final boolean copyTint;

    protected AbstractSimpleEntrySet(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<class_5321<class_1761>> tab, TabAddMode tabMode, BiFunction<T, class_3300, Pair<List<Palette>, @Nullable McMetaFile>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergePalette, boolean copyTint, Predicate<T> condition) {
        this.typeName = (String)(prefix == null ? "" : prefix + (name.isEmpty() ? "" : "_")) + name;
        this.postfix = name;
        this.prefix = prefix;
        this.tab = tab;
        this.tabMode = tabMode;
        this.baseType = baseType;
        this.type = type;
        this.copyTint = copyTint;
        this.extraModelTransform = extraTransform;
        this.paletteSupplier = paletteSupplier;
        this.mergePalette = mergePalette;
        this.nameScheme = this.prefix != null ? (this.postfix.isEmpty() ? Pattern.compile("^" + prefix + "_(.+?)$") : Pattern.compile("^" + prefix + "_(.+?)_" + this.postfix + "$")) : Pattern.compile("^(.+?)_" + this.postfix + "$");
        this.condition = condition;
        if (tab == null && PlatHelper.isDev()) {
            throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set " + this.getName());
        }
    }

    @Override
    public int getBlockCount() {
        return this.blocks.size();
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    @Nullable
    public class_1792 getItemOf(T type) {
        class_1792 i = (class_1792)this.items.get(type);
        if (ModEntriesConfigs.isEntryEnabled(type, (Object)i)) {
            return i;
        }
        return null;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.type;
    }

    public T getBaseType() {
        return (T)((BlockType)this.baseType.get());
    }

    public String getEquivalentBlock(CompatModule module, String oldName, String woodFrom) {
        BlockType w;
        String wood = this.parseWoodType(oldName);
        if (wood != null && (w = BlockSetAPI.getBlockSet(this.getTypeClass()).get(new class_2960(woodFrom, wood))) != null) {
            return module.shortenedId() + "/" + w.getNamespace() + "/" + oldName;
        }
        return null;
    }

    @Nullable
    public String parseWoodType(String oldName) {
        Matcher m = this.nameScheme.matcher(oldName);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public void registerBlockColors(ClientHelper.BlockColorEvent event) {
        if (this.copyTint) {
            ColoringUtils.copyBlockTint(event, this.blocks);
        }
    }

    @Override
    public void registerItemColors(ClientHelper.ItemColorEvent event) {
        if (this.copyTint) {
            ColoringUtils.copyBlockTint(event, this.blocks);
            ColoringUtils.copyItemTint(event, this.items);
        }
    }

    @Override
    public void registerItemsToExistingTabs(SimpleModule module, RegHelper.ItemToTabEvent event) {
        block7: {
            class_5321<class_1761> tab;
            block8: {
                block6: {
                    if (this.tab == null) {
                        if (PlatHelper.isDev()) {
                            throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set " + this.getName());
                        }
                        return;
                    }
                    tab = this.tab.get();
                    if (tab.method_29177().equals((Object)NO_TAB_MARKER)) {
                        return;
                    }
                    if (!class_7923.field_44687.method_35842(tab)) {
                        throw new UnsupportedOperationException("Creative tab " + String.valueOf(tab) + " not registered found in the registries. This means that the target mod must have changed its name. You can either downgrade the mod" + tab.method_29177().method_12836() + " or wait for an Every Compat update");
                    }
                    if (this.tabMode != TabAddMode.AFTER_ALL) break block6;
                    event.add(tab, (class_1935[])this.items.values().toArray(new class_1792[0]));
                    break block7;
                }
                if (this.tabMode != TabAddMode.AFTER_SAME_WOOD) break block8;
                BlockTypeRegistry reg = BlockSetAPI.getBlockSet(this.type);
                for (Map.Entry<T, I> e : this.items.entrySet()) {
                    class_1792 item = (class_1792)e.getValue();
                    BlockType wood = (BlockType)e.getKey();
                    event.addAfter(tab, s -> reg.getBlockTypeOf((class_1935)s.method_7909()) == wood, new class_1935[]{item});
                }
                break block7;
            }
            if (this.tabMode != TabAddMode.AFTER_SAME_TYPE) break block7;
            BlockTypeRegistry reg = BlockSetAPI.getBlockSet(this.type);
            String childKey = this.getChildKey(module);
            Class typeClass = this.getTypeClass();
            for (Map.Entry<T, I> e : this.items.entrySet()) {
                class_1792 item = (class_1792)e.getValue();
                event.addAfter(tab, s -> {
                    BlockType type = reg.getBlockTypeOf((class_1935)s.method_7909());
                    if (type == null) {
                        return false;
                    }
                    return type.getClass() == typeClass && Objects.equals(type.getChildKey((Object)s.method_7909()), childKey);
                }, new class_1935[]{item});
            }
        }
    }

    @Override
    public void generateTags(SimpleModule module, DynamicDataPack pack, class_3300 manager) {
        if (!this.tags.isEmpty()) {
            for (Map.Entry<class_2960, Set<class_5321<?>>> tb : this.tags.entrySet()) {
                SimpleTagBuilder builder = SimpleTagBuilder.of((class_2960)tb.getKey());
                for (Map.Entry<T, ?> entry : this.getDefaultEntries().entrySet()) {
                    if (!ModEntriesConfigs.isEntryEnabled((BlockType)entry.getKey(), entry.getValue())) continue;
                    builder.addEntry(entry.getValue());
                }
                for (class_5321 class_53212 : tb.getValue()) {
                    pack.addTag(builder, class_53212);
                }
            }
        }
        if (PlatHelper.isModLoaded((String)"sullysmod")) {
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of((class_6862)class_3481.field_33715);
            for (Map.Entry<T, B> e : this.blocks.entrySet()) {
                BlockType woodType = (BlockType)e.getKey();
                class_2248 class_22482 = (class_2248)e.getValue();
                if (!woodType.getTypeName().equals("petrified")) continue;
                tagBuilder.addEntry((Object)class_22482);
            }
            pack.addTag(tagBuilder, class_7924.field_41254);
        }
    }

    public Map<T, ?> getDefaultEntries() {
        return this.blocks;
    }

    @Override
    public void generateRecipes(SimpleModule module, DynamicDataPack pack, class_3300 manager) {
        int i = 0;
        for (Supplier<class_2960> r : this.recipeLocations) {
            class_2960 res = r.get();
            try {
                ResourcesUtils.addBlocksRecipes(manager, pack, this.items, res, (BlockType)this.baseType.get(), i++);
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("Failed to generate recipes for template at location {} ", (Object)res, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateTextures(SimpleModule module, DynClientResourcesGenerator handler, class_3300 manager) {
        if (this.textures.isEmpty()) {
            return;
        }
        ArrayList<TextureImage> images = new ArrayList<TextureImage>();
        try (TextureImage oakPlanksTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)((class_2248)this.getBaseType().mainChild())));){
            Palette oakPlanksPalette = Palette.fromImage((TextureImage)oakPlanksTexture);
            HashMap<class_2960, Respriter> respriters = new HashMap<class_2960, Respriter>();
            HashMap<class_2960, TextureImage> partialRespriters = new HashMap<class_2960, TextureImage>();
            Palette globalPalette = Palette.ofColors(new ArrayList());
            ArrayListMultimap infoPerTextures = ArrayListMultimap.create();
            for (TextureInfo textureInfo : this.textures) {
                class_2960 textureId = textureInfo.texture();
                try {
                    class_2960 maskId = textureInfo.mask();
                    TextureImage main = TextureImage.open((class_3300)manager, (class_2960)textureId);
                    main.getMetadata();
                    infoPerTextures.put((Object)textureId, (Object)textureInfo);
                    if (textureInfo.copyTexture()) {
                        respriters.put(textureId, Respriter.ofPalette((TextureImage)main, List.of(Palette.ofColors(List.of(new RGBColor(0))))));
                        continue;
                    }
                    images.add(main);
                    if (maskId != null) {
                        if (textureInfo.autoMask()) {
                            if (this.mergePalette) {
                                globalPalette.addAll((Collection)oakPlanksPalette);
                                partialRespriters.put(textureId, main);
                                continue;
                            }
                            respriters.put(textureId, Respriter.ofPalette((TextureImage)main, (Palette)oakPlanksPalette));
                            continue;
                        }
                        TextureImage mask = TextureImage.open((class_3300)manager, (class_2960)maskId);
                        if (this.mergePalette) {
                            globalPalette.addAll((Collection)Palette.fromImage((TextureImage)main, (TextureImage)mask, (float)0.0f));
                            partialRespriters.put(textureId, main);
                            continue;
                        }
                        respriters.put(textureId, Respriter.masked((TextureImage)main, (TextureImage)mask));
                        continue;
                    }
                    if (this.mergePalette) {
                        globalPalette.addAll((Collection)Palette.fromImage((TextureImage)main, null, (float)0.0f));
                        partialRespriters.put(textureId, main);
                        continue;
                    }
                    respriters.put(textureId, Respriter.of((TextureImage)main));
                }
                catch (UnsupportedOperationException e) {
                    EveryCompat.LOGGER.error("Could not generate textures for {}", (Object)textureInfo, (Object)e);
                }
                catch (Exception e) {
                    if (PlatHelper.isDev()) {
                        throw new RuntimeException(e);
                    }
                    EveryCompat.LOGGER.error("Failed to read block texture at {}", (Object)textureInfo, (Object)e);
                }
            }
            for (Map.Entry entry : partialRespriters.entrySet()) {
                respriters.put((class_2960)entry.getKey(), Respriter.ofPalette((TextureImage)((TextureImage)entry.getValue()), (Palette)globalPalette));
            }
            for (Map.Entry entry : this.getDefaultEntries().entrySet()) {
                Object block = entry.getValue();
                BlockType blockType = (BlockType)entry.getKey();
                class_2960 blockId = Utils.getID(block);
                Pair<List<Palette>, McMetaFile> pal = this.paletteSupplier.apply(blockType, manager);
                McMetaFile targetAnimation = (McMetaFile)pal.getSecond();
                List targetPalette = (List)pal.getFirst();
                if (targetPalette == null) {
                    EveryCompat.LOGGER.error("Could not get texture palette for block {} : ", block);
                    continue;
                }
                int oldSize = ((Palette)targetPalette.get(0)).size();
                for (Map.Entry re : respriters.entrySet()) {
                    if (oldSize != ((Palette)targetPalette.get(0)).size()) {
                        throw new RuntimeException("This should not happen");
                    }
                    class_2960 oldTextureId = (class_2960)re.getKey();
                    String oldPath = oldTextureId.method_12832();
                    String newPath = oldPath.startsWith("entity/") && module.modId.equals("boatload") ? BlockTypeResTransformer.replaceFullGenericType((String)oldPath, (BlockType)blockType, (class_2960)blockId, (String)((BlockType)this.baseType.get()).getTypeName(), null, (int)2) : BlockTypeResTransformer.replaceTypeNoNamespace((String)oldPath, (BlockType)blockType, (class_2960)blockId, (String)((BlockType)this.baseType.get()).getTypeName());
                    String newId = "";
                    boolean isOnAtlas = true;
                    for (TextureInfo info : infoPerTextures.get((Object)oldTextureId)) {
                        if (info != null) {
                            newId = info.keepNamespace() ? oldTextureId.method_45136(newPath).toString() : new class_2960(blockId.method_12836(), newPath).toString();
                            if (newId.isEmpty()) {
                                EveryCompat.LOGGER.error("The path of new texture is empty for: {}", (Object)info.texture());
                                continue;
                            }
                            isOnAtlas = info.onAtlas();
                            if (info.copyMCMETA()) {
                                class_2960 mcmetaLoc = ResType.MCMETA.getPath(oldTextureId);
                                Optional getMCMETA = manager.method_14486(mcmetaLoc);
                                if (getMCMETA.isPresent()) {
                                    InputStream mcmetaStream = ((class_3298)getMCMETA.get()).method_14482();
                                    JsonObject mcmetaFile = RPUtils.deserializeJson((InputStream)mcmetaStream);
                                    ((DynamicTexturePack)handler.dynamicPack).addJson(class_2960.method_12829((String)newId), (JsonElement)mcmetaFile, ResType.MCMETA);
                                    mcmetaStream.close();
                                } else {
                                    handler.getLogger().error("The MCMETA file may no longer existing, check @ {}", (Object)mcmetaLoc);
                                }
                            }
                        }
                        Respriter respriter = (Respriter)re.getValue();
                        Supplier<TextureImage> textureSupplier = () -> respriter.recolorWithAnimation(targetPalette, targetAnimation);
                        textureSupplier = this.postProcessTexture(blockType, newId, manager, textureSupplier);
                        handler.addTextureIfNotPresent(manager, newId, textureSupplier, isOnAtlas);
                    }
                }
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not generate any block texture for entry set {}: {}", (Object)(module == null ? "dummy" : module.modRes(this.getName())), (Object)e.getMessage());
        }
        finally {
            for (TextureImage t : images) {
                t.close();
            }
        }
    }

    public Supplier<TextureImage> postProcessTexture(T blockType, String newId, class_3300 manager, Supplier<TextureImage> textureSupplier) {
        Supplier<TextureImage> changed;
        if (blockType.getClass() == WoodType.class && (changed = SpriteHelper.maybePostProcessWoodTexture((WoodType)blockType, newId, manager, textureSupplier)) != null) {
            return changed;
        }
        return textureSupplier;
    }

    private static Pair<List<Palette>, @Nullable McMetaFile> getPaletteFromMainChild(BlockType w, class_3300 manager) {
        Pair pair;
        block12: {
            class_1935 mainChild = w.mainChild();
            class_2248 mainWoodTypeBlock = null;
            if (mainChild instanceof class_2248) {
                class_2248 bb;
                mainWoodTypeBlock = bb = (class_2248)mainChild;
            } else if (mainChild instanceof class_1747) {
                class_1747 bii = (class_1747)mainChild;
                mainWoodTypeBlock = bii.method_7711();
            }
            if (mainWoodTypeBlock == null) {
                throw new UnsupportedOperationException("You need to provide a palette supplier for non block main child");
            }
            TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)mainWoodTypeBlock));
            try {
                List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                McMetaFile animation = plankTexture.getMcMeta();
                pair = Pair.of((Object)targetPalette, (Object)animation);
                if (plankTexture == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (plankTexture != null) {
                        try {
                            plankTexture.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return Pair.of(null, null);
                }
            }
            plankTexture.close();
        }
        return pair;
    }

    public static <T extends BlockType> @NotNull Pair<List<Palette>, @Nullable McMetaFile> makePaletteFromChild(Consumer<Palette> paletteTransform, String childKey, Predicate<String> whichSide, T blockType, class_3300 m) {
        Object child = blockType.getChild(childKey);
        if (child instanceof class_2248) {
            Pair pair;
            block28: {
                class_2248 b = (class_2248)child;
                if (whichSide != null) {
                    Pair pair2;
                    block27: {
                        TextureImage blockTexture = TextureImage.open((class_3300)m, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)m, (class_2248)b, whichSide));
                        try {
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)blockTexture);
                            targetPalette.forEach(paletteTransform);
                            pair2 = Pair.of((Object)targetPalette, (Object)blockTexture.getMcMeta());
                            if (blockTexture == null) break block27;
                        }
                        catch (Throwable targetPalette) {
                            try {
                                if (blockTexture != null) {
                                    try {
                                        blockTexture.close();
                                    }
                                    catch (Throwable throwable) {
                                        targetPalette.addSuppressed(throwable);
                                    }
                                }
                                throw targetPalette;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(String.format("Failed to generate palette for %s : %s", blockType, e));
                            }
                        }
                        blockTexture.close();
                    }
                    return pair2;
                }
                TextureImage plankTexture = TextureImage.open((class_3300)m, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)m, (class_2248)b));
                try {
                    List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                    targetPalette.forEach(paletteTransform);
                    pair = Pair.of((Object)targetPalette, (Object)plankTexture.getMcMeta());
                    if (plankTexture == null) break block28;
                }
                catch (Throwable targetPalette) {
                    try {
                        if (plankTexture != null) {
                            try {
                                plankTexture.close();
                            }
                            catch (Throwable throwable) {
                                targetPalette.addSuppressed(throwable);
                            }
                        }
                        throw targetPalette;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("Failed to generate palette for %s : %s", blockType, e));
                    }
                }
                plankTexture.close();
            }
            return pair;
        }
        if (child instanceof class_1792) {
            Pair pair;
            block29: {
                class_1792 i = (class_1792)child;
                TextureImage plankTexture = TextureImage.open((class_3300)m, (class_2960)RPUtils.findFirstItemTextureLocation((class_3300)m, (class_1792)i));
                try {
                    List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                    targetPalette.forEach(paletteTransform);
                    pair = Pair.of((Object)targetPalette, (Object)plankTexture.getMcMeta());
                    if (plankTexture == null) break block29;
                }
                catch (Throwable throwable) {
                    try {
                        if (plankTexture != null) {
                            try {
                                plankTexture.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("Failed to generate palette for %s : %s", blockType, e));
                    }
                }
                plankTexture.close();
            }
            return pair;
        }
        throw new RuntimeException("No child with key \"" + childKey + "\" found for" + String.valueOf(blockType.getId()));
    }

    @Override
    @Nullable
    public class_1792 getItemForECTab(T type) {
        if (this.tab == null) {
            if (PlatHelper.isDev()) {
                throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set " + this.getName());
            }
            EveryCompat.LOGGER.error("Creative tab cant be null. Found null one for entry set {}", (Object)this.getName());
            return null;
        }
        try {
            class_5321<class_1761> tagKey = this.tab.get();
            if (tagKey.method_29177().equals((Object)NO_TAB_MARKER)) {
                return null;
            }
        }
        catch (Exception e) {
            if (PlatHelper.isDev()) {
                throw e;
            }
            EveryCompat.LOGGER.error("Failed to get creative tab for entry set {}", (Object)this.getName(), (Object)e);
            return null;
        }
        return EntrySet.super.getItemForECTab(type);
    }

    protected static class Builder<BL extends Builder<BL, T, B, I>, T extends BlockType, B extends class_2248, I extends class_1792> {
        protected final Class<T> type;
        protected final Supplier<T> baseType;
        protected final String name;
        @Nullable
        protected final String prefix;
        protected Supplier<class_5321<class_1761>> tab = null;
        protected TabAddMode tabMode = TabAddMode.AFTER_SAME_TYPE;
        protected BiFunction<T, class_3300, Pair<List<Palette>, @Nullable McMetaFile>> palette = AbstractSimpleEntrySet::getPaletteFromMainChild;
        protected final Map<class_2960, Set<class_5321<?>>> tags = new HashMap();
        protected final Set<Supplier<class_2960>> recipes = new HashSet<Supplier<class_2960>>();
        protected final Set<TextureInfo> textures = new HashSet<TextureInfo>();
        protected boolean useMergedPalette;
        @Nullable
        protected Consumer<BlockTypeResTransformer<T>> extraModelTransform = null;
        protected Predicate<T> condition = w -> true;
        protected boolean copyTint = false;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType) {
            this.baseType = baseType;
            this.name = name;
            this.prefix = prefix;
            this.type = type;
        }

        public BL addModelTransform(Consumer<BlockTypeResTransformer<T>> transform) {
            this.extraModelTransform = transform;
            return (BL)this;
        }

        public BL requiresChildren(String ... childKeys) {
            this.addCondition(w -> {
                for (String c : childKeys) {
                    if (w.getChild(c) != null) continue;
                    return false;
                }
                return true;
            });
            return (BL)this;
        }

        public BL requiresFromMap(Map<T, ?> entrySet) {
            this.addCondition(blockType -> !Objects.isNull(entrySet.get(blockType)));
            return (BL)this;
        }

        public BL excludeBlockTypes(String regEx) {
            this.addCondition(blockType -> !blockType.getId().toString().matches(regEx));
            return (BL)this;
        }

        public BL excludeBlockTypes(String modId, String ... typeIds) {
            StringBuilder regexBuilder = new StringBuilder();
            regexBuilder.append(modId).append(":(");
            for (int i = 0; i < typeIds.length; ++i) {
                regexBuilder.append(typeIds[i]);
                if (i == typeIds.length - 1) continue;
                regexBuilder.append("|");
            }
            regexBuilder.append(")");
            this.addCondition(blockType -> !blockType.getId().toString().matches(regexBuilder.toString()));
            return (BL)this;
        }

        public BL addCondition(Predicate<T> newCondition) {
            this.condition = this.condition == null ? newCondition : this.condition.and(newCondition);
            return (BL)this;
        }

        public BL copyParentTint() {
            this.copyTint = true;
            return (BL)this;
        }

        public BL setTabMode(TabAddMode mode) {
            this.tabMode = mode;
            return (BL)this;
        }

        public BL noTab() {
            return this.setTabKey(NO_TAB_MARKER);
        }

        public BL setTabKey(class_2960 res) {
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)res);
            this.tab = () -> key;
            return (BL)this;
        }

        @Deprecated(forRemoval=true)
        public BL setTabKey(Supplier<class_5321<class_1761>> tab) {
            this.tab = tab;
            return (BL)this;
        }

        public BL setTabKey(class_5321<class_1761> key) {
            this.tab = () -> key;
            return (BL)this;
        }

        @Deprecated(forRemoval=true)
        public BL setTab(Supplier<class_1761> tab) {
            this.tab = Suppliers.memoize(() -> (class_5321)class_7923.field_44687.method_29113((Object)((class_1761)tab.get())).get());
            return (BL)this;
        }

        public BL addTag(class_2960 location, class_5321<?> registry) {
            Set s = this.tags.computeIfAbsent(location, b -> new HashSet());
            s.add(registry);
            return (BL)this;
        }

        public BL addTag(class_6862<?> tag, class_5321<?> registry) {
            this.addTag(tag.comp_327(), registry);
            return (BL)this;
        }

        public BL addRecipe(class_2960 resourceLocation) {
            this.recipes.add(() -> resourceLocation);
            return (BL)this;
        }

        public BL addTexture(TextureInfo.Builder textureLoc) {
            if (PlatHelper.getPhysicalSide().isClient()) {
                TextureInfo info = textureLoc.build();
                this.textures.add(info);
                if (info.keepNamespace()) {
                    ((DynamicTexturePack)ClientDynamicResourcesHandler.getInstance().dynamicPack).addNamespaces(new String[]{info.texture().method_12836()});
                }
            }
            return (BL)this;
        }

        public BL addTexture(class_2960 resourceLocation) {
            return this.addTexture(TextureInfo.of(resourceLocation));
        }

        public BL addTextureM(class_2960 textureLocation, class_2960 maskLocation) {
            return this.addTexture(TextureInfo.of(textureLocation).mask(maskLocation));
        }

        public BL addTextureAutoM(class_2960 textureLocation) {
            return this.addTexture(TextureInfo.of(textureLocation).autoMask());
        }

        public BL useMergedPalette() {
            this.useMergedPalette = true;
            return (BL)this;
        }

        public BL setPalette(BiFunction<T, class_3300, Pair<List<Palette>, @Nullable McMetaFile>> paletteProvider) {
            this.palette = paletteProvider;
            return (BL)this;
        }

        public BL createPaletteFromPlanks(Consumer<Palette> paletteTransform) {
            return this.createPaletteFromChild(paletteTransform, "planks");
        }

        public BL createPaletteFromPlanks() {
            return this.createPaletteFromPlanks(p -> {});
        }

        public BL createPaletteFromChild(Consumer<Palette> paletteTransform, String childKey) {
            return this.createPaletteFromChild(paletteTransform, childKey, null);
        }

        public BL createPaletteFromChild(String childKey, Predicate<String> whichSide) {
            return this.createPaletteFromChild(p -> {}, childKey, whichSide);
        }

        public BL createPaletteFromChild(String childKey) {
            return this.createPaletteFromChild(p -> {}, childKey, null);
        }

        public BL createPaletteFromChild(Consumer<Palette> paletteTransform, String childKey, Predicate<String> whichSide) {
            return this.setPalette((blockType, m) -> AbstractSimpleEntrySet.makePaletteFromChild(paletteTransform, childKey, whichSide, blockType, m));
        }
    }
}

